//=============================================================================
// BB_WindowSelector_f22.js
//=============================================================================

/*:
 * @plugindesc ウインドウスキンを切り替えるプラグイン。
 * @author ビービー
 *
 * @param WindowID
 * @desc 指定したIDの変数が1の時にWindow1、2の時にWindow2、3のときにWindow3が表示されます。
 * それ以外のときはデフォルト(Window0)が表示されます。default：0
 * @default 0
 * 
 * @param OpacityID
 * @desc 指定したIDの変数の数値によってウインドウの透明度を調節します。default：0
 * @default 0
 * 
 * @param OpacityDefault
 * @desc ウインドウの透明度の初期値を設定します。default：192
 * @default 192
 * 
 * @help
 * 
 * WindowID：パラメータで指定したIDの変数が1の時にWindow1、2の時にWindow2、3のときにはWindow3が表示されます。
 *           それ以外のときはデフォルトのWindowを表示します。
 * 
 * OpacityID：パラメータで指定したIDの変数でウインドウの透明度を設定できます。
 *            OpacityDefaultとの合計値が表示されます。
 *            透明度範囲＝0～255
 * 
 * OpacityDefault：ウインドウの透明度の初期値を設定します。
 * 
 * --------------------------------------------------------------------------
 * 
 * ※タイトル画面はデフォルトのウィンドウを固定で表示します。
 * 
 * 利用規約：
 * 作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 * についても制限はありません。
 * 
 * BLOG:http://bb-entertainment-blog.blogspot.jp/
 *
 */

(function() {

    var parameters = PluginManager.parameters('BB_WindowSelector_f22');
    var BBWSwid = Number(parameters['WindowID'] || '0');
    var BBWSoid = Number(parameters['OpacityID'] || '0');
    var BBWSodf = Number(parameters['OpacityDefault'] || '192');

    // 画像の読み込み
    var _Scene_Boot_prototype_loadSystemWindowImage = Scene_Boot.prototype.loadSystemWindowImage;
    Scene_Boot.prototype.loadSystemWindowImage = function() {
        _Scene_Boot_prototype_loadSystemWindowImage.call(this);
        ImageManager.loadSystem('Window0');
        ImageManager.loadSystem('Window1');
        ImageManager.loadSystem('Window2');
        ImageManager.loadSystem('Window3');
    };

    // ウインドウ画像の切り替え
    var _Window_Base_prototype_update = Window_Base.prototype.update;
    Window_Base.prototype.update = function() {
        if(SceneManager._scene.constructor === Scene_Title){
            this.windowskin = ImageManager.loadSystem('Window0');
        } else {
            switch($gameVariables.value(BBWSwid)){
                case 1: this.windowskin = ImageManager.loadSystem('Window1'); break;
                case 2: this.windowskin = ImageManager.loadSystem('Window2'); break;
                case 3: this.windowskin = ImageManager.loadSystem('Window3'); break;
                default : this.windowskin = ImageManager.loadSystem('Window0');
            }
            this.backOpacity = $gameVariables.value(BBWSoid) + BBWSodf;
        }
        _Window_Base_prototype_update.call(this);
    };

})();